package doABC;

import java.nio.*;
import java.util.*;
import FlashReader.*;

/**
 * @author Mariusz
 *
 */
public class MethodInfo extends SwfTools {
	
	private int id;
	public static int method_count;
	
	private HashMap<Integer, String> flagsKind = new HashMap<Integer, String>();
	private AbcFile abc;
	private CpoolInfo cpool;
	
	private int start=0;
	private int end=0;
	
	//struktura
	private int param_count;
	private int return_type;
	private ArrayList<Integer>  param_type= new ArrayList<Integer>() ;
	private int name;
	private int flags;
	private OptionInfo oinfo=null; //optional
	private ArrayList<Integer> param_info= new ArrayList<Integer>() ; //optional
	
	
	public MethodInfo(AbcFile abc, int param_count, int return_type,ArrayList<Integer>  param_type
			,int name, String flags, OptionInfo oinfo, ArrayList<Integer> param_info){
		super();
		this.abc= abc;
		this.cpool = abc.getConstant_pool();
		abc.ENmethod_info.add(this);
		initFlags();
		id = abc.ENmethod_info.size()-1;
			this.param_count = param_count;
			this.return_type = return_type;
		if ( param_type!= null){
			for (Integer param: param_type)
				this.param_type.add(param);
		}
			this.name = name;
			
			setFlags(flags);

		if ( oinfo!=null)
			this.oinfo = oinfo;
		if ( param_info!=null){
			for (Integer param : param_info)
				this.param_info.add(param);
		}
		method_count++;
	}
	
	private MethodInfo(AbcFile abc){
		super();
		
		this.abc= abc;
		this.cpool = abc.getConstant_pool();
		abc.ENmethod_info.add(this);
		initFlags();
		id = abc.ENmethod_info.size()-1;
	}
	
	private void initFlags(){
		flagsKind.put(0x00,"NO_FLAGS");
		flagsKind.put(0x01,"NEED_ARGUMENTS");
		flagsKind.put(0x02,"NEED_ACTIVATION" );
		flagsKind.put(0x04,"NEED_REST" );
		flagsKind.put(0x08,"HAS_OPTIONAL" );
		flagsKind.put(0x40,"SET_DXNS" );
		flagsKind.put(0x80,"HAS_PARAM_NAMES" );
	}
	
	public static void method_info(ByteBuffer bbuf, int position, CpoolInfo cpool,AbcFile abc){
		
		try{
			
		bbuf.position(position);
		
		method_count = unsigned30int(bbuf);
	
		if (method_count>0){
				for (int i =0; i< method_count;i++){
					
					MethodInfo method_info = new MethodInfo(abc);
					
					method_info.start = bbuf.position();
					
					method_info.param_count = unsigned30int(bbuf);

					method_info.return_type = unsigned30int(bbuf);
					
					for (int ii=0;ii < method_info.param_count;ii++)
						method_info.param_type.add(unsigned30int(bbuf));
					
					method_info.name = unsigned30int(bbuf);
					
					method_info.flags = unsignedByte(bbuf.get());

					if ( (method_info.flags & 0x08)!=0 )
						method_info.oinfo = new OptionInfo(bbuf,method_info.param_count,abc);
					
					if ((method_info.flags & 0x80)!=0 ){
													
							for (int i2=0;i2<method_info.param_count;i2++)
								method_info.param_info.add(unsigned30int(bbuf));
					
					}
				method_info.end = bbuf.position()-1;
				
				
				}
				
		}
		
		}catch(Exception e){
			e.printStackTrace();
		}

	}

	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();

			for (byte b: getUI32(param_count))
				result.add(b);
	
			for (byte b: getUI32(return_type))
				result.add(b);
	
			for(int i =0; i < param_type.size();i++){
				for (byte b: getUI32(param_type.get(i)))
					result.add(b);     
			}
		
			for (byte b: getUI32(name))
				result.add(b);
		
			result.add((byte)flags);
		
			if (oinfo!=null){
				for (byte b: oinfo.toByteCode())
					result.add(b);		
			}
			
			for(int i =0; i < param_info.size();i++){
				for (byte b: getUI32(param_info.get(i)))
					result.add(b);            
			}
		

		return result;
	}
	
	//getters
	
	public int getId() {
		return id;
	}
	
	public OptionInfo getOinfo() {
		return oinfo;
	}
	
	public int getReturn_type() {
		cpool.setZeroString("*");
		return return_type;
	}
	
	public String getReturn_type_string() {
		return cpool.getMultiname(return_type);
	}

	public ArrayList<Integer>getParam_type() {
		cpool.setZeroString("*");
		return param_type;
	}
	
	public ArrayList<String> getParam_type_string() {
		ArrayList<String> result= new ArrayList<String>();
		for (int i =0; i < param_count; i++) result.add(cpool.getMultiname(param_type.get(i)));
		return result;
	}

	public int getName() {
		cpool.setZeroString("NO_NAME");
		return name;
	}
	
	public String getName_string() {
		return cpool.getString(name);
	}

	public String getFlags() {
		return flagsKind.get(flags);
	}


	public ArrayList<Integer> getParam_info() {
		cpool.setZeroString("NO_NAME");
		return param_info;
	}
	
	public ArrayList<String> getParam_info_string() {
		if ((flags & 0x80)!=0 ){
			ArrayList<String> result= new ArrayList<String>();
			for (int i =0; i < param_info.size(); i++) 
				result.add(cpool.getStrings_string().get(param_info.get(i)));
			return result;
		}else return  new ArrayList<String>();
	}

	
	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public int getParam_count() {
		return param_count;
	}
	
	public int getFlags(String flags) {
		return (Integer)getKeyFromValue(flagsKind, flags);
	}
	
	public HashMap<Integer, String> getFlagsKind() {
		return flagsKind;
	}
	
	//Setters
	
	public void removeMethod(int id){
		abc.ENmethod_info.remove(id);
		method_count--;
	}
	
	public void changeMethod(int id, MethodInfo method_info){
		abc.ENmethod_info.set(id, method_info);
	}

	public void setParam_count(int param_count) {
		this.param_count = param_count;
		out("ok");
	}

	public void setReturn_type(int return_type) {
		this.return_type = return_type;
		out("ok");
	}

	
	public void setName(int name) {
		this.name = name;
		out("ok");
	}

	public void setFlags(int flags) {
		this.flags = flags;
		out("ok");
	}
	
	public void setFlags(String flags) {
		if (flags !=null){
			this.flags = (Integer)getKeyFromValue(flagsKind, flags);
			out("ok");
		}else
			this.flags =0;
	}
	

	public void setParam_info(ArrayList<Integer> param_info) throws Exception {
		if ((flags & 0x08)!=0 ){
			this.param_info = param_info;
			out("ok");
		}
		else throw new Exception("Flaga musi by ustawiona na 0x08");
		
	}

	public void setOinfo(OptionInfo oinfo) throws Exception {
		if ((flags & 0x08)!=0 ){
			this.oinfo = oinfo;
			out("ok");
		}
		else throw new Exception("Flaga musi by ustawiona na 0x08");
	}

	public void addParamInfo(Integer value) throws Exception{
		if ((flags & 0x80)!=0 ){
			param_info.add(value);
			out("ok");
		}
		else throw new Exception("Flaga musi by ustawiona na 0x08");
	}
	
	public void removeParamInfo(int id) throws Exception{
			param_info.remove(id);
			out("ok");
	}

	public void changeParamInfo(int id, Integer value) throws Exception{
		if ((flags & 0x80)!=0 ){
			param_info.set(id, value);
			out("ok");
		}
		else throw new Exception("Flaga musi by ustawiona na 0x08");
	}
	
	
	public void addParamType(Integer value) throws Exception{
			param_type.add(value);
			param_count++;
			out("ok");
	}

	public void removeParamType(int id)throws Exception {	
		param_type.remove(id);
		param_count= param_count-1;
		out("ok");
	}

	public void changeParamType(int id, Integer value) throws Exception{
			param_type.set(id, value);
			out("ok");
	}

	public  String String(){
		StringBuffer wynik = new StringBuffer();

			wynik.append( ">" +  getStart()+"\n" );
		
			wynik.append( "param_count: " + getParam_count()+"\n" );
			
			wynik.append( "return_type: " + getReturn_type_string()+"\n" );
			
			wynik.append( "param_type: " +  getParam_type_string()+"\n" );
			
			wynik.append( "name: " +getName_string()+"\n" );
			
			wynik.append( "flags: " +getFlags()+"\n" );
			
			//wynik += "option_info: " + getOinfo()+"\n";
			
			wynik.append( "param_info: " +  getParam_info_string()+"\n" );
	
			wynik.append( "<" + getEnd() +"\n" );
		

		return wynik.toString();
	
	}

	//toStrings

	public String toString(){
		String wynik ="";
		wynik+="method_info " + "id " + id + " "+start+ " - " + end;
		return wynik;
	}
	public String toString2(){
		String wynik ="";
		wynik+="method_info";
		return wynik;
	}

	
}
